<?php
/**
 * Plugin Name: wpZeo - Zero SEO
 * Plugin URI: https://example.com/wpzeo-zero-seo
 * Description: Lean SEO essentials for WordPress: metadata, social tags, sitemap, robots.txt and simple redirects.
 * Version: 0.1.0
 * Author: wpZeo
 * License: GPL-2.0-or-later
 * Text Domain: wpzeo-zero-seo
 * Requires at least: 6.3
 * Requires PHP: 7.4
 */

if (! defined('ABSPATH')) {
	exit;
}

define('WPZEO_VERSION', '0.1.0');
define('WPZEO_FILE', __FILE__);
define('WPZEO_PATH', plugin_dir_path(__FILE__));
define('WPZEO_URL', plugin_dir_url(__FILE__));

try {
	require_once WPZEO_PATH . 'includes/Core/Plugin.php';

	if (! class_exists('WPZEO\\Core\\Plugin')) {
		if (function_exists('error_log')) {
			error_log('[wpZeo] Boot error: WPZEO\\Core\\Plugin class missing after include.');
		}

		if (function_exists('deactivate_plugins') && function_exists('plugin_basename')) {
			deactivate_plugins(plugin_basename(WPZEO_FILE), true);
		}
		return;
	}

	register_activation_hook(WPZEO_FILE, ['WPZEO\\Core\\Plugin', 'activate']);
	register_deactivation_hook(WPZEO_FILE, ['WPZEO\\Core\\Plugin', 'deactivate']);
	WPZEO\Core\Plugin::instance();
} catch (\Throwable $exception) {
	if (function_exists('error_log')) {
		error_log('[wpZeo] Boot error: ' . $exception->getMessage());
	}

	if (function_exists('deactivate_plugins') && function_exists('plugin_basename')) {
		deactivate_plugins(plugin_basename(WPZEO_FILE), true);
	}
}
