<?php

if (! defined('WP_UNINSTALL_PLUGIN')) {
	exit;
}

delete_option('wpzeo_modules');
delete_option('wpzeo_settings_general');
delete_option('wpzeo_settings_sitemap');
delete_option('wpzeo_settings_social');
delete_option('wpzeo_settings_robots');
delete_option('wpzeo_settings_redirects');
delete_option('wpzeo_settings_redirect_stats');
delete_option('wpzeo_settings_migration');
delete_option('wpzeo_last_migration_report');

$post_meta_keys = [
	'_wpzeo_title',
	'_wpzeo_description',
	'_wpzeo_focus_keyword',
	'_wpzeo_robots',
	'_wpzeo_canonical',
	'_wpzeo_og_image',
	'_wpzeo_og_title',
	'_wpzeo_og_description',
	'_wpzeo_twitter_title',
	'_wpzeo_twitter_description',
	'_wpzeo_twitter_image',
	'_wpzeo_robots_advanced',
	'_wpzeo_exclude_sitemap',
];

foreach ($post_meta_keys as $key) {
	delete_metadata('post', 0, $key, '', true);
}

$term_meta_keys = [
	'_wpzeo_term_title',
	'_wpzeo_term_description',
	'_wpzeo_term_focus_keyword',
	'_wpzeo_term_robots',
	'_wpzeo_term_canonical',
	'_wpzeo_term_og_image',
	'_wpzeo_term_content',
	'_wpzeo_term_content_post_id',
];

foreach ($term_meta_keys as $key) {
	delete_metadata('term', 0, $key, '', true);
}

$user_meta_keys = [
	'_wpzeo_author_title',
	'_wpzeo_author_description',
	'_wpzeo_author_focus_keyword',
	'_wpzeo_author_robots',
	'_wpzeo_author_canonical',
	'_wpzeo_author_og_image',
	'_wpzeo_author_content',
	'_wpzeo_author_content_post_id',
];

foreach ($user_meta_keys as $key) {
	delete_metadata('user', 0, $key, '', true);
}
