<?php

namespace WPZEO\Core;

use WPZEO\Admin\Admin;
use WPZEO\Modules\Migration;
use WPZEO\Modules\Meta;
use WPZEO\Modules\Redirects;
use WPZEO\Modules\Robots;
use WPZEO\Modules\SettingsApi;
use WPZEO\Modules\Sitemap;
use WPZEO\Modules\Social;

if (! defined('ABSPATH')) {
	exit;
}

require_once WPZEO_PATH . 'includes/Core/Settings.php';
require_once WPZEO_PATH . 'includes/Admin/Admin.php';
require_once WPZEO_PATH . 'includes/Modules/Meta.php';
require_once WPZEO_PATH . 'includes/Modules/Migration.php';
require_once WPZEO_PATH . 'includes/Modules/SettingsApi.php';
require_once WPZEO_PATH . 'includes/Modules/Sitemap.php';
require_once WPZEO_PATH . 'includes/Modules/Robots.php';
require_once WPZEO_PATH . 'includes/Modules/Social.php';
require_once WPZEO_PATH . 'includes/Modules/Redirects.php';

class Plugin
{
	/**
	 * @var Plugin|null
	 */
	private static $instance = null;

	/**
	 * @var Settings
	 */
	private $settings;

	/**
	 * @var array<string, bool>
	 */
	private $modules = [];

	/**
	 * @return Plugin
	 */
	public static function instance()
	{
		if (null === self::$instance) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	private function __construct()
	{
		$this->settings = new Settings();
		$this->modules  = $this->settings->get_modules();

		add_action('plugins_loaded', [$this, 'boot']);
	}

	public function boot()
	{
		new Admin($this->settings);
		new SettingsApi($this->settings);
		new Migration($this->settings);

		if ($this->is_module_enabled('meta')) {
			new Meta($this->settings);
		}

		if ($this->is_module_enabled('sitemap')) {
			new Sitemap($this->settings);
		}

		if ($this->is_module_enabled('robots')) {
			new Robots($this->settings);
		}

		if ($this->is_module_enabled('social')) {
			new Social($this->settings);
		}

		if ($this->is_module_enabled('redirects')) {
			new Redirects($this->settings);
		}
	}

	/**
	 * @param string $module
	 * @return bool
	 */
	private function is_module_enabled($module)
	{
		return ! empty($this->modules[$module]);
	}

	public static function activate()
	{
		$settings = new Settings();
		$settings->ensure_defaults();
		add_rewrite_rule('^wpzeo-sitemap\.xml$', 'index.php?wpzeo_sitemap=1', 'top');
		flush_rewrite_rules();
	}

	public static function deactivate()
	{
		flush_rewrite_rules();
	}
}
