<?php

declare(strict_types=1);

namespace Agent\Support;

final class Options
{
    private string $optionName;
    private array $defaults;

    public function __construct(string $optionName, array $defaults)
    {
        $this->optionName = $optionName;
        $this->defaults = $defaults;
    }

    public function all(): array
    {
        $raw = get_option($this->optionName, []);
        if (! is_array($raw)) {
            return $this->defaults;
        }

        return array_replace_recursive($this->defaults, $raw);
    }

    public function get(string $path, mixed $fallback = null): mixed
    {
        $data = $this->all();
        $segments = explode('.', $path);

        foreach ($segments as $segment) {
            if (! is_array($data) || ! array_key_exists($segment, $data)) {
                return $fallback;
            }
            $data = $data[$segment];
        }

        return $data;
    }

    public function set(string $path, mixed $value): void
    {
        $data = $this->all();
        $segments = explode('.', $path);
        $cursor = &$data;

        foreach ($segments as $segment) {
            if (! isset($cursor[$segment]) || ! is_array($cursor[$segment])) {
                $cursor[$segment] = [];
            }
            $cursor = &$cursor[$segment];
        }

        $cursor = $value;

        update_option($this->optionName, $data, false);
    }

    public function updateAll(array $settings): void
    {
        update_option($this->optionName, array_replace_recursive($this->defaults, $settings), false);
    }
}
