<?php

declare(strict_types=1);

namespace Agent\Modules\Seo;

final class WpZeoAdapter implements SeoAdapterInterface
{
    public function key(): string
    {
        return 'wpzeo';
    }

    public function label(): string
    {
        return 'wpZeo';
    }

    public function isActive(array $activePlugins): bool
    {
        return in_array('wpzeo-zero-seo/wpzeo-zero-seo.php', $activePlugins, true);
    }

    public function writePostMeta(int $postId, array $seo): array
    {
        $written = [];

        $map = [
            'seo_title' => '_wpzeo_title',
            'meta_description' => '_wpzeo_description',
            'robots' => '_wpzeo_robots',
            'canonical' => '_wpzeo_canonical',
            'og_image' => '_wpzeo_og_image',
        ];

        foreach ($map as $field => $metaKey) {
            if (! array_key_exists($field, $seo)) {
                continue;
            }

            $value = trim((string) $seo[$field]);
            update_post_meta($postId, $metaKey, $value);
            $written[] = $metaKey;
        }

        return [
            'status' => 'written',
            'written_meta_keys' => $written,
        ];
    }
}

