<?php

declare(strict_types=1);

namespace Agent\Modules\Seo;

final class RankMathAdapter implements SeoAdapterInterface
{
    public function key(): string
    {
        return 'rank_math';
    }

    public function label(): string
    {
        return 'Rank Math';
    }

    public function isActive(array $activePlugins): bool
    {
        return in_array('seo-by-rank-math/rank-math.php', $activePlugins, true);
    }

    public function writePostMeta(int $postId, array $seo): array
    {
        $written = [];

        $map = [
            'seo_title' => 'rank_math_title',
            'meta_description' => 'rank_math_description',
            'focus_keyword' => 'rank_math_focus_keyword',
            'canonical' => 'rank_math_canonical_url',
            'robots' => 'rank_math_robots',
            'og_title' => 'rank_math_facebook_title',
            'og_description' => 'rank_math_facebook_description',
            'twitter_title' => 'rank_math_twitter_title',
            'twitter_description' => 'rank_math_twitter_description',
        ];

        foreach ($map as $field => $metaKey) {
            if (! array_key_exists($field, $seo)) {
                continue;
            }

            $value = trim((string) $seo[$field]);
            update_post_meta($postId, $metaKey, $value);
            $written[] = $metaKey;
        }

        return [
            'status' => 'written',
            'written_meta_keys' => $written,
        ];
    }
}

