(function (wp) {
    if (!wp || !wp.plugins || !wp.editPost || !wp.element || !wp.components || !wp.data) {
        return;
    }

    var registerPlugin = wp.plugins.registerPlugin;
    var PluginDocumentSettingPanel = wp.editPost.PluginDocumentSettingPanel;
    var createElement = wp.element.createElement;
    var TextControl = wp.components.TextControl;
    var TextareaControl = wp.components.TextareaControl;
    var SelectControl = wp.components.SelectControl;
    var useSelect = wp.data.useSelect;
    var useDispatch = wp.data.useDispatch;

    function SidebarPanel() {
        var meta = useSelect(function (select) {
            return select('core/editor').getEditedPostAttribute('meta') || {};
        }, []);

        var editPost = useDispatch('core/editor').editPost;

        var setMeta = function (key, value) {
            var next = {};
            next[key] = value;
            editPost({ meta: next });
        };

        return createElement(
            PluginDocumentSettingPanel,
            {
                name: 'wpai-ai-assistant-panel',
                title: 'AI Assistant',
                className: 'wpai-ai-assistant-panel',
            },
            createElement(TextControl, {
                label: 'Thema',
                value: meta._wpai_ai_topic || '',
                onChange: function (value) { setMeta('_wpai_ai_topic', value); },
            }),
            createElement(TextControl, {
                label: 'Zielgruppe',
                value: meta._wpai_ai_audience || '',
                onChange: function (value) { setMeta('_wpai_ai_audience', value); },
            }),
            createElement(SelectControl, {
                label: 'Ton-Variante',
                value: meta._wpai_ai_tone_variant || 'neutral',
                options: [
                    { label: 'Neutral', value: 'neutral' },
                    { label: 'Formal', value: 'formal' },
                    { label: 'Persoenlich', value: 'personal' },
                    { label: 'Technisch', value: 'technical' },
                ],
                onChange: function (value) { setMeta('_wpai_ai_tone_variant', value); },
            }),
            createElement(SelectControl, {
                label: 'Laenge',
                value: meta._wpai_ai_length || 'medium',
                options: [
                    { label: 'Kurz', value: 'short' },
                    { label: 'Mittel', value: 'medium' },
                    { label: 'Lang', value: 'long' },
                ],
                onChange: function (value) { setMeta('_wpai_ai_length', value); },
            }),
            createElement(TextareaControl, {
                label: 'Keywords',
                help: 'Kommagetrennte Stichworte',
                value: meta._wpai_ai_keywords || '',
                onChange: function (value) { setMeta('_wpai_ai_keywords', value); },
            })
        );
    }

    registerPlugin('wpai-ai-assistant-sidebar', {
        render: SidebarPanel,
    });
})(window.wp);
