<?php
/**
 * Plugin Name: Agent Bridge
 * Description: API-first integration layer for autonomous coding agents in WordPress.
 * Version: 0.1.0
 * Requires at least: 6.5
 * Requires PHP: 8.1
 * Author: Agent
 * License: GPL-2.0-or-later
 * Text Domain: agent
 */

declare(strict_types=1);

if (! defined('ABSPATH')) {
    exit;
}

spl_autoload_register(
    static function (string $class): void {
        $prefix = 'Agent\\';
        $baseDir = __DIR__ . '/src/';

        if (strpos($class, $prefix) !== 0) {
            return;
        }

        $relativeClass = substr($class, strlen($prefix));
        $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';

        if (is_readable($file)) {
            require $file;
        }
    }
);

function agent_bootstrap(): Agent\Plugin
{
    static $plugin = null;

    if ($plugin instanceof Agent\Plugin) {
        return $plugin;
    }

    $plugin = new Agent\Plugin(__FILE__);
    $plugin->boot();

    return $plugin;
}

add_action('plugins_loaded', 'agent_bootstrap');

register_activation_hook(
    __FILE__,
    static function (): void {
        Agent\Plugin::activate();
    }
);

register_deactivation_hook(
    __FILE__,
    static function (): void {
        Agent\Plugin::deactivate();
    }
);
