<?php

declare(strict_types=1);

namespace Agent\Modules\System;

use Agent\Support\Options;

final class CapabilityMapService
{
    private const KNOWN_CAPABILITIES = [
        'manage_options',
        'activate_plugins',
        'edit_posts',
        'publish_posts',
        'upload_files',
        'agent_read',
    ];

    private Options $options;

    public function __construct(Options $options)
    {
        $this->options = $options;
    }

    public function generate(): array
    {
        $user = wp_get_current_user();
        $allCaps = is_object($user) && is_array($user->allcaps ?? null) ? $user->allcaps : [];

        $capabilities = [];
        foreach (self::KNOWN_CAPABILITIES as $capability) {
            $capabilities[$capability] = current_user_can($capability);
        }

        return [
            'generated_at' => gmdate('c'),
            'actor' => [
                'user_id' => get_current_user_id(),
                'user_login' => is_object($user) ? (string) ($user->user_login ?? '') : '',
                'roles' => is_object($user) && is_array($user->roles ?? null) ? array_values($user->roles) : [],
            ],
            'runtime' => [
                'readonly_mode' => (bool) $this->options->get('readonly_mode', true),
                'full_write_access' => (bool) $this->options->get('full_write_access', false),
                'emergency_lock' => (bool) $this->options->get('emergency_lock', false),
                'modules' => (array) $this->options->get('modules', []),
            ],
            'capabilities' => $capabilities,
            'allcaps_count' => count($allCaps),
        ];
    }
}
