<?php

declare(strict_types=1);

namespace Agent\Modules\Indexing;

final class IndexTablesInstaller
{
    public static function install(): void
    {
        global $wpdb;

        if (! isset($wpdb)) {
            return;
        }

        if (! function_exists('dbDelta')) {
            require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        }

        $charsetCollate = $wpdb->get_charset_collate();
        $tableStatus = $wpdb->prefix . 'ai_index_status';
        $tableGenerations = $wpdb->prefix . 'ai_generations';
        $tableChunks = $wpdb->prefix . 'ai_chunks';
        $tableJobs = $wpdb->prefix . 'ai_jobs';

        $sqlStatus = "CREATE TABLE {$tableStatus} (
            id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
            post_id bigint(20) unsigned NOT NULL,
            last_indexed_at datetime NOT NULL,
            content_hash varchar(64) NOT NULL,
            status varchar(30) NOT NULL,
            PRIMARY KEY  (id),
            KEY post_id (post_id),
            KEY status (status)
        ) {$charsetCollate};";

        $sqlGenerations = "CREATE TABLE {$tableGenerations} (
            id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
            post_id bigint(20) unsigned NOT NULL,
            generated_by_user_id bigint(20) unsigned NOT NULL DEFAULT 0,
            generated_at datetime NOT NULL,
            prompt_version varchar(100) NOT NULL,
            model varchar(120) NOT NULL DEFAULT '',
            context longtext NULL,
            result_summary longtext NULL,
            PRIMARY KEY  (id),
            KEY post_id (post_id),
            KEY generated_at (generated_at)
        ) {$charsetCollate};";

        $sqlChunks = "CREATE TABLE {$tableChunks} (
            id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
            post_id bigint(20) unsigned NOT NULL,
            chunk_no int unsigned NOT NULL,
            heading_path text NULL,
            text longtext NOT NULL,
            embedding longtext NULL,
            created_at datetime NOT NULL,
            updated_at datetime NOT NULL,
            PRIMARY KEY  (id),
            KEY post_id (post_id),
            KEY chunk_no (chunk_no)
        ) {$charsetCollate};";

        $sqlJobs = "CREATE TABLE {$tableJobs} (
            id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
            job_type varchar(80) NOT NULL,
            queue_key varchar(120) NOT NULL DEFAULT '',
            payload_json longtext NOT NULL,
            status varchar(20) NOT NULL DEFAULT 'queued',
            error_code varchar(120) NOT NULL DEFAULT '',
            error_message text NULL,
            failed_step varchar(120) NOT NULL DEFAULT '',
            attempts int unsigned NOT NULL DEFAULT 0,
            created_by bigint(20) unsigned NOT NULL DEFAULT 0,
            created_at datetime NOT NULL,
            scheduled_at datetime NOT NULL,
            started_at datetime NULL,
            finished_at datetime NULL,
            PRIMARY KEY  (id),
            KEY status (status),
            KEY job_type (job_type),
            KEY queue_key (queue_key),
            KEY scheduled_at (scheduled_at)
        ) {$charsetCollate};";

        dbDelta($sqlStatus);
        dbDelta($sqlGenerations);
        dbDelta($sqlChunks);
        dbDelta($sqlJobs);
    }
}
