<?php

declare(strict_types=1);

namespace Agent\Modules\Editor;

final class EditorSidebarModule
{
    private string $pluginFile;

    public function __construct(string $pluginFile)
    {
        $this->pluginFile = $pluginFile;
    }

    public function register(): void
    {
        add_action('init', [$this, 'registerMeta']);
        add_action('enqueue_block_editor_assets', [$this, 'enqueueAssets']);
    }

    public function registerMeta(): void
    {
        $postTypes = get_post_types(['show_in_rest' => true], 'names');
        $keys = [
            '_wpai_ai_topic',
            '_wpai_ai_audience',
            '_wpai_ai_tone_variant',
            '_wpai_ai_length',
            '_wpai_ai_keywords',
        ];

        foreach ($postTypes as $postType) {
            foreach ($keys as $key) {
                register_post_meta(
                    $postType,
                    $key,
                    [
                        'type' => 'string',
                        'single' => true,
                        'show_in_rest' => true,
                        'auth_callback' => static fn (): bool => current_user_can('edit_posts'),
                        'sanitize_callback' => static fn ($value): string => sanitize_text_field((string) $value),
                    ]
                );
            }
        }
    }

    public function enqueueAssets(): void
    {
        wp_enqueue_script(
            'wpai-editor-sidebar',
            plugins_url('assets/js/editor-sidebar.js', $this->pluginFile),
            ['wp-plugins', 'wp-edit-post', 'wp-element', 'wp-components', 'wp-data'],
            '0.1.0',
            true
        );
    }
}
