<?php

declare(strict_types=1);

namespace WpOrchestrator\Security;

final class AccessGuard
{
    public function userCanAccess(): bool
    {
        if (!is_user_logged_in()) {
            return false;
        }

        if (is_super_admin()) {
            return true;
        }

        $user = wp_get_current_user();

        return in_array('administrator', (array) $user->roles, true);
    }

    public function assertAccess(): void
    {
        if ($this->userCanAccess()) {
            return;
        }

        wp_die(
            esc_html__('You are not allowed to access wpOrchestrator.', 'wp-orchestrator'),
            403
        );
    }

    public function assertNonce(string $action, string $nonceField = '_wpnonce'): void
    {
        $nonce = isset($_POST[$nonceField]) ? (string) $_POST[$nonceField] : '';

        if (!wp_verify_nonce($nonce, $action)) {
            wp_die(esc_html__('Security check failed.', 'wp-orchestrator'), 403);
        }
    }
}
