<?php
/**
 * Plugin Name: wpOrchestrator
 * Description: Zentrales Monitoring und Administration fuer mehrere WordPress-Instanzen.
 * Version: 0.1.0
 * Requires at least: 6.6
 * Requires PHP: 8.1
 * Author: wpOrchestrator Team
 * Text Domain: wp-orchestrator
 */

declare(strict_types=1);

if (!defined('ABSPATH')) {
    exit;
}

const WPO_PLUGIN_VERSION = '0.1.0';
const WPO_PLUGIN_FILE = __FILE__;
const WPO_PLUGIN_DIR = __DIR__;

spl_autoload_register(static function (string $class): void {
    $prefix = 'WpOrchestrator\\';

    if (strpos($class, $prefix) !== 0) {
        return;
    }

    $relativeClass = substr($class, strlen($prefix));
    $path = WPO_PLUGIN_DIR . '/src/' . str_replace('\\', '/', $relativeClass) . '.php';

    if (is_readable($path)) {
        require_once $path;
    }
});

function wpo_plugin(): \WpOrchestrator\Plugin
{
    static $plugin = null;

    if ($plugin === null) {
        $plugin = new \WpOrchestrator\Plugin();
    }

    return $plugin;
}

register_activation_hook(WPO_PLUGIN_FILE, static function (): void {
    wpo_plugin()->activate();
});

register_deactivation_hook(WPO_PLUGIN_FILE, static function (): void {
    wpo_plugin()->deactivate();
});

add_action('plugins_loaded', static function (): void {
    wpo_plugin()->boot();
});
