<?php

declare(strict_types=1);

namespace WpOrchestrator\Support;

final class Logger
{
    public function info(string $message, array $context = []): void
    {
        $this->write('info', $message, $context);
    }

    public function error(string $message, array $context = []): void
    {
        $this->write('error', $message, $context);
    }

    private function write(string $level, string $message, array $context): void
    {
        $safeContext = $this->sanitizeContext($context);

        error_log(sprintf(
            '[wpOrchestrator][%s] %s %s',
            strtoupper($level),
            $message,
            wp_json_encode($safeContext)
        ));
    }

    private function sanitizeContext(array $context): array
    {
        $secretKeys = ['password', 'secret', 'auth_secret', 'token', 'authorization'];

        foreach ($context as $key => $value) {
            $normalizedKey = strtolower((string) $key);

            if (in_array($normalizedKey, $secretKeys, true)) {
                $context[$key] = '[redacted]';
            }
        }

        return $context;
    }
}
