<?php

declare(strict_types=1);

namespace WpOrchestrator\Modules\Capabilities;

final class CapabilityResolver
{
    /**
     * @param array<int, string> $namespaces
     * @return array{wpai_available: bool, capabilities: array<string, mixed>}
     */
    public function resolveFromNamespaces(array $namespaces): array
    {
        $normalized = array_values(array_unique(array_map(static fn(string $value): string => strtolower(trim($value)), $namespaces)));
        $wpaiAvailable = in_array('wpai/v1', $normalized, true);

        $capabilities = [
            'source' => 'rest_namespaces',
            'namespaces' => $normalized,
            'wpai' => [
                'available' => $wpaiAvailable,
                'namespace' => $wpaiAvailable ? 'wpai/v1' : null,
            ],
        ];

        return [
            'wpai_available' => $wpaiAvailable,
            'capabilities' => $capabilities,
        ];
    }
}
