<?php

declare(strict_types=1);

namespace WpOrchestrator\Modules\Audit;

final class AuditRepository
{
    public function hasActionRef(string $actionRef): bool
    {
        global $wpdb;

        $table = $wpdb->prefix . 'wpo_audit';
        $count = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(1) FROM {$table} WHERE action_ref = %s",
                $actionRef
            )
        );

        return ((int) $count) > 0;
    }

    /**
     * @param array<string, mixed> $details
     */
    public function addRemoteAudit(int $targetId, string $actionRef, string $outcome, array $details): void
    {
        if ($this->hasActionRef($actionRef)) {
            return;
        }

        $this->insert($targetId, null, $actionRef, $outcome, $details);
    }

    /**
     * @param array<string, mixed> $details
     */
    public function addLocalAudit(int $targetId, int $actorId, string $actionRef, string $outcome, array $details): void
    {
        $this->insert($targetId, $actorId, $actionRef, $outcome, $details);
    }

    /**
     * @param array<string, mixed> $details
     */
    private function insert(int $targetId, ?int $actorId, string $actionRef, string $outcome, array $details): void
    {
        global $wpdb;

        $table = $wpdb->prefix . 'wpo_audit';
        $inserted = $wpdb->insert(
            $table,
            [
                'actor' => $actorId,
                'target_id' => $targetId,
                'action_ref' => $actionRef,
                'outcome' => $outcome,
                'details_json' => wp_json_encode($details),
                'created_at' => current_time('mysql'),
            ],
            ['%d', '%d', '%s', '%s', '%s', '%s']
        );

        if ($inserted !== 1) {
            throw new \RuntimeException('Unable to persist audit event.');
        }
    }
}
