<?php

declare(strict_types=1);

namespace WpOrchestrator\Infrastructure\Database;

final class Migrator
{
    public const SCHEMA_VERSION = '0.1.1';
    public const SCHEMA_OPTION = 'wpo_schema_version';
    public const CRON_HOOK = 'wpo_run_health_checks';
    public const CRON_INTERVAL = 'wpo_five_minutes';

    public function registerCronInterval(array $schedules): array
    {
        $schedules[self::CRON_INTERVAL] = [
            'interval' => 5 * MINUTE_IN_SECONDS,
            'display' => __('Every 5 Minutes (wpOrchestrator)', 'wp-orchestrator'),
        ];

        return $schedules;
    }

    public function migrate(): void
    {
        global $wpdb;

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';

        $charsetCollate = $wpdb->get_charset_collate();
        $targets = $wpdb->prefix . 'wpo_targets';
        $checks = $wpdb->prefix . 'wpo_checks';
        $actions = $wpdb->prefix . 'wpo_actions';
        $audit = $wpdb->prefix . 'wpo_audit';

        $sql = [];

        $sql[] = "CREATE TABLE {$targets} (
            id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
            name VARCHAR(190) NOT NULL,
            base_url VARCHAR(255) NOT NULL,
            auth_user VARCHAR(190) NOT NULL,
            auth_secret_enc LONGTEXT NOT NULL,
            tags TEXT NULL,
            status VARCHAR(50) NOT NULL DEFAULT 'active',
            wpai_available TINYINT(1) NOT NULL DEFAULT 0,
            capabilities_json LONGTEXT NULL,
            last_seen_at DATETIME NULL,
            created_at DATETIME NOT NULL,
            updated_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY base_url_unique (base_url),
            KEY status_idx (status)
        ) {$charsetCollate};";

        $sql[] = "CREATE TABLE {$checks} (
            id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
            target_id BIGINT UNSIGNED NOT NULL,
            check_type VARCHAR(100) NOT NULL,
            result_json LONGTEXT NOT NULL,
            score SMALLINT UNSIGNED NULL,
            created_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            KEY target_check_idx (target_id, check_type),
            KEY created_idx (created_at)
        ) {$charsetCollate};";

        $sql[] = "CREATE TABLE {$actions} (
            id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
            target_id BIGINT UNSIGNED NOT NULL,
            action_uuid CHAR(36) NOT NULL,
            action_type VARCHAR(100) NOT NULL,
            payload_json LONGTEXT NULL,
            status VARCHAR(50) NOT NULL,
            started_at DATETIME NULL,
            finished_at DATETIME NULL,
            created_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY action_uuid_unique (action_uuid),
            KEY target_status_idx (target_id, status)
        ) {$charsetCollate};";

        $sql[] = "CREATE TABLE {$audit} (
            id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
            actor BIGINT UNSIGNED NULL,
            target_id BIGINT UNSIGNED NULL,
            action_ref VARCHAR(100) NULL,
            outcome VARCHAR(50) NOT NULL,
            details_json LONGTEXT NULL,
            created_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            KEY target_created_idx (target_id, created_at),
            KEY outcome_idx (outcome)
        ) {$charsetCollate};";

        foreach ($sql as $statement) {
            dbDelta($statement);
        }

        update_option(self::SCHEMA_OPTION, self::SCHEMA_VERSION, false);
    }
}
